# -*- coding: utf-8 -*-
import logging
import uuid

import sandbox
from sandbox.projects.browser.autotests.classes.diff_tickets import get_diff_tickets, get_issue_obj
from sandbox.projects.browser.autotests.classes.regression_manager.common_desktop import _DBroRegressionManager
from sandbox.projects.browser.autotests.classes.group_regression_manager.webntp_desktop import WebntpDbroGroupRegressionManager
from sandbox.projects.browser.autotests.classes.testing_job import TestingJob, JobExecutors


logger = logging.getLogger(__file__)


class WebntpDBroRegressionManager(_DBroRegressionManager):

    group_regresson_manager_class = WebntpDbroGroupRegressionManager
    ticket_jinja_template_package = "webntp_dbro_regressoin"
    regression_type_name = 'Desktop WebNTP'

    def get_builds_info(self, stand_data):
        return {
            "distribution_type": stand_data["distribution_type"],
            "distribution_name": stand_data["distribution_name"],
            "build_id": stand_data["build_id"]
        }

    @property
    @sandbox.common.utils.singleton
    def tested_builds(self):
        res = {}
        for item in self._context.correct_browser_builds:
            res.setdefault(
                item["distribution_type"], {}).setdefault(
                    item["distribution_name"], {})[item["build_id"]] = self.clients.teamcity.Build(id=item['build_id'])

            # additional reference to compatibility
            if "browser_build" not in res:
                res["browser_build"] = self.clients.teamcity.Build(id=item['build_id'])
        return res

    @property
    @sandbox.common.utils.singleton
    def autotests_bundle(self):
        return None

    @sandbox.common.utils.singleton
    def _suites_2_jobs(self):
        jobs = []
        for suite in self.test_suites:
            cases = self.load_suite_cases(suite.id,
                                          suite.project)
            suite_object = self.clients.testpalm.get_testsuite(suite.id, suite.project)
            for case in cases:
                if not self.should_check_case(case, suite):
                    continue

                if suite.disable_assessors:
                    executor = JobExecutors.manual.value
                    testrun_environments = suite.manual_platforms or suite.assessors_platforms
                elif self.is_assessors(case):
                    executor = JobExecutors.assessor.value
                    testrun_environments = suite.assessors_platforms
                else:
                    executor = JobExecutors.manual.value
                    testrun_environments = suite.manual_platforms

                if not testrun_environments:
                    logger.warning(u'Для {}-кейса {} нет платформ'.format(executor, case.url))

                case_grouping_fields = []
                for field in getattr(suite_object, "groups", []):
                    grouping_values = case.attributes.get(field, [])
                    if grouping_values:
                        case_grouping_fields.append(grouping_values[0])

                for stand in self._context.correct_browser_builds:
                    _jobs = [TestingJob(uuid=uuid.uuid4().hex,
                                        case_id=case.id,
                                        case_project=case.project,
                                        testrun_environment=_env,
                                        build_info=self.get_builds_info(stand),
                                        executor=executor,
                                        component=self.get_component(case),
                                        is_automated=self.is_automated(case, _env),
                                        estimate=case.estimate,
                                        case_grouping_fields=case_grouping_fields,
                                        suite_info=dict(id=suite.id, tags=suite.tags, project=case.project,
                                                        url=suite_object.pretty_str(),
                                                        aggregate_manual_runs=suite.aggregate_manual_runs,
                                                        aggregate_asessors_runs=suite.aggregate_asessors_runs))
                             for _env in testrun_environments]

                    jobs += _jobs

        return jobs

    # Base diff
    def get_diff_issues(self):
        if not self._parameters.previous_external_ntp_build_id:
            raise RuntimeError(u"Не указана предыдущая сборка")

        if not self._context.diff_issues:
            new_issues, maybe_new_issues, old_issues, report = get_diff_tickets(
                project='stardust', repo='web-ntp',
                old_build_id=self._parameters.previous_external_ntp_build_id,
                new_build_id=self._parameters.external_ntp_build_id,
                teamcity_client=self.clients.teamcity,
                bb_client=self.clients.bitbucket,
                startrek_client=self.clients.prod_startrek)

            self._context.diff_issues = (
                [issue.key for issue in new_issues],
                [issue.key for issue in maybe_new_issues],
                [issue.key for issue in old_issues],
            )

        return (
            [get_issue_obj(self.clients.prod_startrek, issue) for issue in issues]
            for issues in self._context.diff_issues
        )

    def _get_diff_builds_urls(self):
        old_build_url = self.clients.teamcity.Build(
            id=self._parameters.previous_external_ntp_build_id).web_url
        new_build_url = self.clients.teamcity.Build(
            id=self._parameters.external_ntp_build_id).web_url
        return old_build_url, new_build_url
