# -*- coding: utf-8 -*-
import time


def get_booking_state(ya_booking_client, booking_id):
    result = {
        "problems": [],
        "available_time": 0
    }

    booking_info = ya_booking_client.get_booking_info(booking_id)
    if booking_info is None:
        result["problems"].append(u'Бронь booking_id={} не найдена или не существует'.format(
            booking_id))
    elif booking_info["status"].upper() != "ACTIVE":
        result["problems"].append(
            u'Бронь booking_id={} имеет не валидный статус: {}'.format(
                booking_id, booking_info["status"]))

    if not result["problems"]:
        slot_size_seconds = int(booking_info["estimate"]["minQuota"] / booking_info["estimate"]["resourceVolume"]) * 60
        result["available_time"] = int(booking_info["estimate"]["startTs"] / 1000) + slot_size_seconds - int(time.time())

    return result
