

def load_suites_info(test_suites):
    import marshmallow

    class SuiteInfo(object):
        class Schema(marshmallow.Schema):
            id = marshmallow.fields.String(required=True)
            project = marshmallow.fields.String(required=True)
            assessors_platforms = marshmallow.fields.List(marshmallow.fields.String(), required=True)
            manual_platforms = marshmallow.fields.List(marshmallow.fields.String(), required=True)
            tags = marshmallow.fields.List(marshmallow.fields.String(), required=False)
            filter_by_diff = marshmallow.fields.Bool(required=False)

            @marshmallow.post_load
            def make_suite_info(self, data):
                return SuiteInfo(**data)

        def __init__(self, id, project, assessors_platforms, manual_platforms, filter_by_diff=None, tags=None):
            self.manual_platforms = manual_platforms
            self.assessors_platforms = assessors_platforms
            self.project = project
            self.id = id
            self.tags = tags or []
            self.filter_by_diff = filter_by_diff or False

    class SuitesInfo(object):
        class Schema(marshmallow.Schema):
            testsuites = marshmallow.fields.List(
                marshmallow.fields.Nested(SuiteInfo.Schema), required=True)

            @marshmallow.post_load
            def make_suites(self, data):
                return SuitesInfo(**data)

        def __init__(self, testsuites):
            self.testsuites = testsuites

    return SuitesInfo.Schema(strict=True).load(test_suites).data
