import argparse
import os

from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport import TESTPALM_API_HOST


def _parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--testpalm-token-env', default=None, dest='testpalm_token_env',
                        help='Environment variable with testpalm token')
    parser.add_argument('--from-project', dest='origin', help='from what project tpo copy definitions',
                        default='brocase')
    parser.add_argument('--to-project', dest='to', help='to what project copy definition', )
    parser.add_argument('--suite', help='suite to copy')
    parser.add_argument('--cases', nargs='*', help='cases to copy')
    parser.add_argument('--ignore-fields', dest='ignore', default=[
        'id', 'lastModifiedTime', 'bugs', 'stats', 'tasks', 'createdBy',
    ])
    return parser.parse_args()


if __name__ == '__main__':
    from testpalm_api_client.client import TestPalmClient

    args = _parse_args()

    client = TestPalmClient(host=TESTPALM_API_HOST, oauth_token=os.environ[args.testpalm_token_env])
    cases = client.get_testsuite_cases(args.suite, args.origin)
    if args.cases:
        for case_id in args.cases:
            cases.append(client.get_testcase(case_id))

    cases = [
        {
            k: v for k, v in case.iteritems()
            if k not in args.ignore
        }
        for case in cases
    ]
    client.create_testcases(cases, project=args.to)
