import argparse
import os

from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport import TESTPALM_API_HOST


def _parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--testpalm-token-env', default=None, dest='testpalm_token_env',
                        help='Environment variable with testpalm token')
    parser.add_argument('--from-project', dest='origin', help='from what project tpo copy definitions',
                        default='brocase')
    parser.add_argument('--to-project', dest='to', help='to what project copy definition', )
    parser.add_argument('--definitions', nargs='*', help='definitions to copy',
                        default=['Component', 'Brand ID', 'Partner ID', 'Checklist', 'Is automated', 'Automated OS',
                                 'Automated Brand', ])
    parser.add_argument('--definition-properties', dest='properties', help='what fields of definitions copy',
                        default=['values', 'description', 'id', 'title'])
    return parser.parse_args()


if __name__ == '__main__':
    from testpalm_api_client.client import TestPalmClient

    args = _parse_args()

    client = TestPalmClient(host=TESTPALM_API_HOST, oauth_token=os.environ[args.testpalm_token_env])
    definitions_from = client.get_definitions(project=args.origin)
    definitions_from = [
        {
            k: v for k, v in d.iteritems()
            if k in args.properties or not args.properties
        } for d in definitions_from if d['title'] not in args.definitions or not args.definitions
    ]
    for definition in definitions_from:
        client.create_definition(definition, project=args.to)
