import sandbox
from sandbox.projects.browser.autotests.regression.dbro.DiffTickets.builds_diff_issues import get_components
from sandbox.projects.browser.autotests.BrowserAutotestTestpalmExport import ROBOT_USERAGENT, ST_BASE_API_URL
from sandbox.projects.browser.autotests.regression.dbro.DiffTickets import builds_diff_issues
from sandbox.projects.browser.autotests_qa_tools.common import (
    ROBOT_BRO_QA_INFRA_TOKEN_VAULT, get_st_browser_version, TEAMCITY_URL)
from sandbox.projects.browser.common import bitbucket
from sandbox.projects.browser.common.bitbucket import DEFAULT_BITBUCKET_URL
from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.environments import PipEnvironment

ISSUES_QUERY = ('queue:browser status:resolved "Fix Version":{version}'
                ' components:!Merge components:!Technological'
                ' components:!Autotests components:!SpeedInfra components:!Regression'
                ' components:!Unit-tests components:!Sanity')


class TicketsDiff(sdk2.Resource):
    ttl = 30
    share = True


def create_testpalm_filter(components):
    return '({})'.format(
        ' OR '.join('"Component"="{}"'.format(component) for component in components)
    )


class BrowserDiffTickets(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 150
        cores = 1
        client_tags = ctc.Tag.Group.LINUX & ctc.Tag.BROWSER
        environments = [
            PipEnvironment('teamcity-client==3.0.0'),
            PipEnvironment('startrek_client', version='1.7.0', use_wheel=True),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.String('Mode') as mode:
            mode.values.BUILDS = mode.Value('Diff between builds', default=True)
            mode.values.COMMITS = mode.Value('Diff between commits')

        with mode.value['BUILDS']:
            old_build = sdk2.parameters.Integer('Old build', required=True)
            new_build = sdk2.parameters.Integer('New build', required=True)
            query = sdk2.parameters.String(
                'Startrek query', description='This issues will be added to diff from builds',
                default=ISSUES_QUERY, required=False, )
        with mode.value['COMMITS']:
            old_commit = sdk2.parameters.String('Old commit', required=True)
            new_commit = sdk2.parameters.String('New commit', required=True)
        project = sdk2.parameters.String('Bitbucket project', required=True, default='stardust')
        repo = sdk2.parameters.String('Bitbucket repository', required=True, default='browser')

    def on_execute(self):
        query = self.Parameters.query if self.Parameters.mode == 'BUILDS' else None

        if query:
            version = get_st_browser_version(self.teamcity_client.Build(id=self.Parameters.new_build))
            query = query.format(version=version)
        new_issues, maybe_new_issues, old_issues, issues_by_query, report = builds_diff_issues.get_diff_tickets(
            bb_client=self.bitbucket_client, teamcity_client=self.teamcity_client,
            new_build_id=self.Parameters.new_build, old_build_id=self.Parameters.old_build,
            startrek_client=self.startrek_client, repo=self.Parameters.repo, project=self.Parameters.project,
            old_commit=self.Parameters.old_commit, new_commit=self.Parameters.new_commit, query=query,
        )

        with open(str(self.path('ticket_diff.html')), 'w') as f:
            f.write(report)
        diff_resource = TicketsDiff(
            self, 'Diff issues',
            str(self.path('ticket_diff.html')))
        self.set_info('Diff: <a href="{0}">{0}</a>'.format(diff_resource.http_proxy), do_escape=False)
        self.Context.tickets_report = diff_resource.http_proxy
        components_by_project = get_components(new_issues, maybe_new_issues, old_issues, issues_by_query)
        self.set_info(
            '<br/>'.join(
                'Testpalm filter for project <b>{}</b>: {}'.format(project, create_testpalm_filter(components))
                for project, components in components_by_project.iteritems()
            ), do_escape=False
        )

    @property
    @sandbox.common.utils.singleton
    def bitbucket_client(self):
        return bitbucket.BitBucket(DEFAULT_BITBUCKET_URL, 'x-oauth-token',
                                   sdk2.Vault.data(ROBOT_BRO_QA_INFRA_TOKEN_VAULT))

    @property
    @sandbox.common.utils.singleton
    def startrek_client(self):
        from startrek_client import Startrek
        return Startrek(
            useragent=ROBOT_USERAGENT,
            token=sdk2.Vault.data(ROBOT_BRO_QA_INFRA_TOKEN_VAULT),
            base_url=ST_BASE_API_URL)

    @property
    @sandbox.common.utils.singleton
    def teamcity_client(self):
        import teamcity_client.client
        return teamcity_client.client.TeamcityClient(
            server_url=TEAMCITY_URL,
            auth=sdk2.Vault.data(ROBOT_BRO_QA_INFRA_TOKEN_VAULT)
        )
