# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.browser.autotests.regression_tasks.configs import RegressionConfigs
from sandbox.projects.browser.autotests.regression_tasks.BaseBrowserRegression import BaseBrowserRegression
from sandbox.projects.browser.autotests.regression_tasks.BaseMobileBrowserRegression import BaseMobileBrowserRegression
from sandbox.projects.browser.autotests.classes.regression_manager.android import AndroidRegressionManager

CONFIGS_MODULE = RegressionConfigs.android.value


class BaseAndroidBrowserRegression(BaseMobileBrowserRegression):

    regression_manager_class = AndroidRegressionManager
    configs_module = CONFIGS_MODULE

    class Parameters(BaseMobileBrowserRegression.Parameters):

        with sdk2.parameters.Group('Regression scope settings') as scope_params:
            regression_type = sdk2.parameters.String(
                'Regression type', required=True, choices=[(_, _) for _ in CONFIGS_MODULE.TEST_SUITE_CONFIGS + ['custom']],
                ui=sdk2.parameters.String.UI('select')
            )

            with regression_type.value['custom']:
                test_suites_override = BaseBrowserRegression.Parameters.test_suites()

    def check_input(self):
        build_problems = super(BaseAndroidBrowserRegression, self).check_input()
        if self.Parameters.diff_type == "functionalities_diff":
            build_problems.append(u'Дифф по функциональностям для Android регрессий не реализован, '
                                  u'переключите параметр "Diff type" на компонентный дифф или отключите его')

        builds = self.get_builds()
        browser_build, tests_build = builds.get("browser_build"), builds.get("tests_build")
        if (self.Parameters.enable_autotests and (not tests_build or not browser_build)):
            build_problems.append(u'Включен флаг использования автотестов (enable_autotests),'
                                  u' для чего требуются build_id и browser_tests_build_id')
        return build_problems
