# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.browser.autotests.regression_tasks.configs import RegressionConfigs
from sandbox.projects.browser.autotests.regression_tasks.BaseBrowserRegression import BaseBrowserRegression
from sandbox.projects.browser.autotests.regression_tasks.BaseMobileBrowserRegression import BaseMobileBrowserRegression
from sandbox.projects.browser.autotests.classes.regression_manager.searchapp_ios import SearchappIosRegressionManager

CONFIGS_MODULE = RegressionConfigs.searchapp_ios.value


class BaseSearchappIosRegression(BaseMobileBrowserRegression):

    regression_manager_class = SearchappIosRegressionManager
    configs_module = CONFIGS_MODULE

    class Parameters(BaseMobileBrowserRegression.Parameters):

        with sdk2.parameters.Group('Regression scope settings') as scope_params:
            regression_type = sdk2.parameters.String(
                'Regression type', required=True, choices=[(_, _) for _ in CONFIGS_MODULE.TEST_SUITE_CONFIGS + ['custom']],
                ui=sdk2.parameters.String.UI('select')
            )

            with regression_type.value['custom']:
                test_suites_override = BaseBrowserRegression.Parameters.test_suites()
