# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.browser.autotests.regression_tasks.configs import RegressionConfigs
from sandbox.projects.browser.autotests.regression_tasks.BaseBrowserRegression import BaseBrowserRegression
from sandbox.projects.browser.autotests.regression_tasks.BaseMobileBrowserRegression import BaseMobileBrowserRegression
from sandbox.projects.browser.autotests.classes.regression_manager.alicekit import AlicekitRegressionManager

CONFIGS_MODULE = RegressionConfigs.alicekit.value


class RunAlicekitBrowserRegression(BaseMobileBrowserRegression):

    regression_manager_class = AlicekitRegressionManager
    configs_module = CONFIGS_MODULE

    class Parameters(BaseMobileBrowserRegression.Parameters):

        skip_builds_consistency_check = None
        build_id = None
        old_build_id = None
        fake_build_id = None
        browser_tests_build_id = None
        enable_autotests = None
        requester_code = None

        with sdk2.parameters.Group('Regression scope settings') as scope_params:
            regression_type = sdk2.parameters.String(
                'Regression type', required=True, choices=[(_, _) for _ in CONFIGS_MODULE.TEST_SUITE_CONFIGS + ['custom']],
                ui=sdk2.parameters.String.UI('select')
            )
            with regression_type.value['custom']:
                test_suites_override = BaseBrowserRegression.Parameters.test_suites()

        with sdk2.parameters.RadioGroup("Diff type") as diff_type:
            diff_type.values.functionalities_diff = diff_type.Value("Functionalities diff")
            diff_type.values.component_diff = diff_type.Value("Component diff")
            diff_type.values.disabled = diff_type.Value("Diff disabled", default=True)
