# -*- coding: utf-8 -*-
from copy import deepcopy
from enum import Enum

from sandbox.projects.browser.autotests.regression_tasks.configs import (
    alicekit_test_suites_configs, android_test_suites_configs, dbro_test_suites_configs,
    distribution_dbro_test_suites_configs, ios_test_suites_configs, searchapp_ios_test_suites_configs,
    searchapp_android_test_suites_configs, webntp_dbro_test_suites_configs)


SCHEME_FILE_NAME = "_scheme.json"
DEFAULT_SETTINGS_FILE_NAME = "_default_settings.yaml"
SETTINGS_SCHEME_FILE_NAME = "_regression_settings_scheme.json"


class RegressionConfigs(Enum):

    dbro = dbro_test_suites_configs
    distribution_dbro = distribution_dbro_test_suites_configs
    android = android_test_suites_configs
    alicekit = alicekit_test_suites_configs
    ios = ios_test_suites_configs
    searchapp_ios = searchapp_ios_test_suites_configs
    searchapp_android = searchapp_android_test_suites_configs
    webntp_dbro = webntp_dbro_test_suites_configs


def validate_regression_config(config_data, config_scheme, settings_scheme, avalible_groups, all_settings_required):
    # Принимает предустановленный или кастомный конфиг из таски
    merged_scheme = deepcopy(config_scheme)
    merged_scheme["settings"] = deepcopy(settings_scheme)
    from jsonschema import validate
    _scheme = deepcopy(merged_scheme)
    # Принимает предустановленный или кастомный конфиг из таски
    if not all_settings_required:
        _scheme["settings"].pop("required")

    validate(config_data, _scheme)
    if "settings" in config_data:
        validate_regression_settings(config_data["settings"],
                                     settings_scheme,
                                     avalible_groups=avalible_groups,
                                     all_settings_required=all_settings_required)


def validate_regression_settings(settings, settings_scheme, avalible_groups, all_settings_required):
    from jsonschema import validate
    _scheme = deepcopy(settings_scheme)
    if not all_settings_required:
        _scheme.pop("required")

    validate(settings, _scheme)

    # groups и default_group должны быть согасованы
    groups = settings.get("groups")
    default_group = settings.get("default_group")
    if groups is not None or default_group is not None or all_settings_required:
        assert groups and default_group, "groups and default_group must be announced synchronously"
        assert default_group in groups, "default_group must be in the groups list"
        assert all(_g in avalible_groups for _g in groups), "All groups must be on the list testing_groups.yaml"
