import datetime
import urllib


ASSESSORS_BUCKET = 'broinfra-autotests-assessors'
S3_KEY_DATE_FORMAT = '%Y-%m'
_ASSESSORS_PROXY_URL = 'https://infra-asessor.browser.yandex-team.ru/s3'


def make_s3_client(boto3, aws_access_key_id, aws_secret_access_key):
    session = boto3.session.Session(
        aws_access_key_id=aws_access_key_id,
        aws_secret_access_key=aws_secret_access_key,
    )
    return session.client(
        service_name='s3',
        endpoint_url='https://s3.mds.yandex.net',
    )


def get_s3_key_prefix(task_id):
    today = datetime.date.today().strftime(S3_KEY_DATE_FORMAT)
    return '/'.join((today, str(task_id)))


def upload_file_to_s3(s3_client, src, s3_key_prefix, filename):
    dst = '/'.join((s3_key_prefix, filename))
    s3_client.upload_file(
        Filename=src,
        Bucket=ASSESSORS_BUCKET,
        Key=dst,
        ExtraArgs={'ContentType': 'application/octet-stream'},
    )


def upload_fileobj_to_s3(s3_client, fileobj, s3_key_prefix, filename):
    dst = '/'.join((s3_key_prefix, filename))
    s3_client.upload_fileobj(
        Fileobj=fileobj,
        Bucket=ASSESSORS_BUCKET,
        Key=dst,
        ExtraArgs={'ContentType': 'application/octet-stream'},
    )


def get_s3_proxy_url(s3_key_prefix, filename):
    s3_filepath = urllib.quote('/'.join((s3_key_prefix, filename)))
    return '/'.join((_ASSESSORS_PROXY_URL, ASSESSORS_BUCKET, s3_filepath))
