# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.common_desktop import _DbroGroupRegressionManager


logger = logging.getLogger(__file__)


class DbroGroupRegressionManager(_DbroGroupRegressionManager):

    honey_logs_cases = {
        "brocase": 13379,
        "bro-morda-zen": 607,
        "zenlib_browser": 415
    }
    assessor_files_order = {
        "Network": [
            'build',
            'lite_installer',
            'arc',
            'mini_installer',
            'rss',
            'fake',
            'fake_mini_installer',
            'fake_rss',
        ],
        "default": [
            'build',
        ]
    }
    ticket_jinja_template_package = "dbro_regression"

    @sandbox.common.utils.singleton
    def get_assessor_version(self, run_template):
        return self._get_testpalm_version(
            self.assessor_version_template,
            run_template["project"],
            unique=True,
            description="version: {}".format(self.tested_builds["browser_build"].number.split('/')[0]))
