# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.common_desktop import _DbroGroupRegressionManager


logger = logging.getLogger(__file__)


class DistributionDbroGroupRegressionManager(_DbroGroupRegressionManager):

    ticket_jinja_template_package = "distr_dbro_regressoin"

    def continue_regression(self, *args, **kwargs):
        raise NotImplementedError()

    @property
    @sandbox.common.utils.singleton
    def group_ticket_properties(self):
        res = super(DistributionDbroGroupRegressionManager, self).group_ticket_properties
        res.setdefault('links', []).append(
            {
                'relationship': "relates",
                'issue': self._parameters.release_ticket
            }
        )
        return res

    @property
    @sandbox.common.utils.singleton
    def tested_builds(self):
        res = {}
        if self._parameters.browser_build_alice:
            res["alice"] = self.clients.teamcity.Build(id=self._parameters.browser_build_alice)
        if self._parameters.browser_build_noalice:
            res["noalice"] = self.clients.teamcity.Build(id=self._parameters.browser_build_noalice)

        # additional reference to compatibility
        res["browser_build"] = res.get("alice", None) or res["noalice"]
        return res

    @sandbox.common.utils.singleton
    def get_assessors_links(self, run_template):
        return self._main_context.assessors_links[run_template["build_info"]["build_type"]][
            run_template["build_info"]["distribution_type"]][
            run_template["build_info"]["distribution_name"]]

    def get_assessor_run_title(self, version, run_template, platform):
        return u'[{version}][{platform}][{component}][{build_type}][{distribution_type}/{distribution_name}] Part {part}'.format(
            version=version,
            part=run_template["part"],
            component=run_template["component"],
            distribution_type=run_template["build_info"]["distribution_type"],
            distribution_name=run_template["build_info"]["distribution_name"],
            build_type=run_template["build_info"]["build_type"],
            platform=self.platform)

    def render_group_ticket_template(self):
        return self.group_ticket_template.render(
            launch_comment=self._parameters.manual_launch_comment,
            alice_build=self.tested_builds["alice"].web_url if "alice" in self.tested_builds else None,
            no_alice_build=self.tested_builds["noalice"].web_url if "noalice" in self.tested_builds else None
        )

    @sandbox.common.utils.singleton
    def get_assessor_version(self, run_template):
        return self._get_testpalm_version(
            "{}_{}_{}".format(self.assessor_version_template,
                              run_template["build_info"]["distribution_type"],
                              run_template["build_info"]["distribution_name"]),
            run_template["project"],
            unique=True)

    def publish_group_diff_tickets(self, *args, **kwargs):
        raise NotImplementedError()

    def comment_about_ticket_diff(self, *args, **kwargs):
        raise NotImplementedError()
