# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.common_desktop import _DbroGroupRegressionManager


logger = logging.getLogger(__file__)


class WebntpDbroGroupRegressionManager(_DbroGroupRegressionManager):

    ticket_jinja_template_package = "webntp_dbro_regressoin"

    def continue_regression(self, *args, **kwargs):
        raise NotImplementedError()

    @property
    def st_version(self):
        return "Dev"

    @property
    @sandbox.common.utils.singleton
    def tested_builds(self):
        res = {}
        for item in self._main_context.correct_browser_builds:
            res.setdefault(
                item["distribution_type"], {}).setdefault(
                    item["distribution_name"], {})[item["build_id"]] = self.clients.teamcity.Build(id=item['build_id'])

            # additional reference to compatibility
            if "browser_build" not in res:
                res["browser_build"] = self.clients.teamcity.Build(id=item['build_id'])
        return res

    @sandbox.common.utils.singleton
    def get_assessors_links(self, run_template):
        return self._main_context.assessors_links[run_template["build_info"]["distribution_type"]][
            run_template["build_info"]["distribution_name"]][
            run_template["build_info"]["build_id"]]

    def get_assessor_run_title(self, version, run_template, platform):
        return u'[{version}][{platform}][{component}][{build_type}/{distribution_type}/{distribution_name}] Part {part}'.format(
            version=version,
            part=run_template["part"],
            component=run_template["component"],
            distribution_type=run_template["build_info"]["distribution_type"],
            distribution_name=run_template["build_info"]["distribution_name"],
            build_type=run_template["build_info"]["build_id"],
            platform=self.platform)

    @sandbox.common.utils.singleton
    def get_assessor_version(self, run_template):
        return self._get_testpalm_version(
            "{}_{}_{}_{}".format(self.assessor_version_template,
                                 run_template["build_info"]["build_id"],
                                 run_template["build_info"]["distribution_type"],
                                 run_template["build_info"]["distribution_name"]),
            run_template["project"],
            unique=True)

    @property
    def assessor_version_template(self):
        return '_'.join(
            [self.version_number,
             self.platform,
             self._parameters.asessor_version_title or self._parameters.regression_type.replace(".yaml", "", 1),
             self.group.name])

    def render_group_ticket_template(self):
        return self.group_ticket_template.render(
            launch_comment=self._parameters.manual_launch_comment,
            builds=self._main_context.assessors_links
        )

    @property
    @sandbox.common.utils.singleton
    def assessors_ticket_properties(self):
        properties = self._assessors_ticket_properties
        properties["affectedVersions"] = ["Dev"]
        properties['deadline'] = self._main_context.deadline
        return properties

    @property
    @sandbox.common.utils.singleton
    def group_ticket_properties(self):
        properties = self._group_ticket_properties
        properties["affectedVersions"] = ["Dev"]
        return properties

    @property
    @sandbox.common.utils.singleton
    def ticket_summary_template(self):
        return u"[ExternalNtp] Регресс версии"
