# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.autotests_bundle import get_android_bro_autotest_bundle
from sandbox.projects.browser.autotests_qa_tools.classes.regression_manager.common_mobile import MobileRegressionManager
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.android import AndroidGroupRegressionManager

logger = logging.getLogger(__file__)


class AndroidRegressionManager(MobileRegressionManager):

    group_regresson_manager_class = AndroidGroupRegressionManager
    regression_type_name = 'Android + Core'

    @property
    def tested_application(self):
        return 'browser'

    @property
    @sandbox.common.utils.singleton
    def autotests_bundle(self):
        if not self._parameters.enable_autotests or self._context.autotests_timeout <= 0 or not self.tested_builds.get(
                "tests_build"):
            return None
        browser_build = self.tested_builds.get("browser_build")
        return get_android_bro_autotest_bundle(self.tested_builds["tests_build"].id,
                                               browser_build.id if browser_build else None,
                                               self.clients)
