# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.regression_manager.common_desktop import _DBroRegressionManager

logger = logging.getLogger(__file__)


class DBroRegressionManager(_DBroRegressionManager):

    regression_type_name = 'Desktop'

    @property
    @sandbox.common.utils.singleton
    def default_group(self):
        group = super(DBroRegressionManager, self).default_group
        if self._parameters.main_regression_ticket_assignee:
            group.participants.insert(0, self._parameters.main_regression_ticket_assignee)
        return group

    def get_builds_info(self, suite):
        return {
            "distribution_type": self._parameters.distribution_type,
            "distribution_name": self._parameters.distribution_name,
            "build_type": None
        }

    def get_automated_info(self):
        result = None
        automated_cases = set(
            ("{}-{}".format(_j["case_project"], _j["case_id"]), _j["testrun_environment"])
            for _j in self.regression_jobs if _j["is_automated"])

        if automated_cases:
            launch_config = self.autotests_bundle.get_launch_config_by_cases(automated_cases)
            if launch_config is not None:
                result = {
                    "launch_config": launch_config,
                    "browser_branch": self.autotests_bundle.browser_branch,
                    "browser_commit": self.autotests_bundle.browser_commit,
                    "build_extra_args": self.autotests_bundle.build_extra_args,
                    "number_of_shards": self.autotests_bundle.number_of_shards,
                    "tested_application": self.autotests_bundle.tested_application,
                    "summary": {
                        "total_count": len(self.regression_jobs),
                        "automated_count": len(automated_cases)
                    }}
            else:
                logger.error("Empty bundle autotest_config for automated cases")
        return result


# This is a temporary class. It is used in BrowserCalculateFunctionalitiesProfit task and is a implementation of "old"
# logic of choosing what cases to run in regression.
class DBroRegressionManagerWithComponents(DBroRegressionManager):

    def is_case_in_diff(self, case):
        if self._parameters.diff_type == "disabled":
            return True
        else:
            return self.is_case_in_component_diff(case)
