# -*- coding: utf-8 -*-
import logging

import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.regression_manager.common_desktop import _DBroRegressionManager
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.distribution_desktop import DistributionDbroGroupRegressionManager

logger = logging.getLogger(__file__)


class DistributionDBroRegressionManager(_DBroRegressionManager):

    group_regresson_manager_class = DistributionDbroGroupRegressionManager
    ticket_jinja_template_package = "distr_dbro_regressoin"
    regression_type_name = 'Desktop distribution'

    class SuiteInfo(object):
        def __init__(self, id, project, distribution_type, distribution_name, build_type,
                     assessors_platforms, manual_platforms, tags=None,
                     comment=None, aggregate_manual_runs=False,
                     aggregate_asessors_runs=False, honey_logs=False, disable_assessors=False):
            self.manual_platforms = manual_platforms
            self.assessors_platforms = assessors_platforms
            self.project = project
            self.id = id
            self.distribution_type = distribution_type
            self.distribution_name = distribution_name
            self.build_type = build_type
            self.tags = tuple(tags or [])
            self.comment = comment or ""
            self.aggregate_manual_runs = aggregate_manual_runs or False
            self.aggregate_asessors_runs = aggregate_asessors_runs or False
            self.honey_logs = honey_logs or False
            self.disable_assessors = disable_assessors or False

    def get_builds_info(self, suite):
        return {
            "distribution_type": suite.distribution_type,
            "distribution_name": suite.distribution_name,
            "build_type": suite.build_type
        }

    @property
    @sandbox.common.utils.singleton
    def tested_builds(self):
        res = {}
        if self._parameters.browser_build_alice:
            res["alice"] = self.clients.teamcity.Build(id=self._parameters.browser_build_alice)
        if self._parameters.browser_build_noalice:
            res["noalice"] = self.clients.teamcity.Build(id=self._parameters.browser_build_noalice)

        # additional reference to compatibility
        res["browser_build"] = res.get("alice", None) or res["noalice"]
        return res

    def should_check_case(self, case, suite):
        if not any(os.startswith(self.platform) for os in case.oses):
            logger.warning(u'Кейс {} не для {} платформы'.format(case.url, self.platform))
            return False
        if suite.build_type not in self.tested_builds:
            logger.warning(u'Нет сборки {} для сьюта {}'.format(suite.build_type, suite.id))
            return False

        return True

    @property
    def main_ticket(self):
        if self._context.main_ticket is None:
            self._context.main_ticket = self._parameters.configuration_ticket
        return self._context.main_ticket

    @property
    @sandbox.common.utils.singleton
    def autotests_bundle(self):
        return None

    def is_case_in_diff(self, case):
        raise NotImplementedError()

    def is_case_in_component_diff(self, case):
        raise NotImplementedError()

    def is_case_in_functionalities_diff(self, case):
        raise NotImplementedError()

    @property
    def diff_functionalities(self):
        raise NotImplementedError()

    # Base diff
    def get_diff_issues(self):
        raise NotImplementedError()

    def publish_diff_tickets(self):
        raise NotImplementedError()
