# -*- coding: utf-8 -*-
import sandbox
from sandbox.projects.browser.autotests_qa_tools.classes.autotests_bundle import get_android_searchapp_autotest_bundle
from sandbox.projects.browser.autotests_qa_tools.classes.regression_manager.common_mobile import MobileRegressionManager
from sandbox.projects.browser.autotests_qa_tools.classes.group_regression_manager.searchapp_android import SearchappAndroidGroupRegressionManager


class SearchappAndroidRegressionManager(MobileRegressionManager):

    group_regresson_manager_class = SearchappAndroidGroupRegressionManager
    regression_type_name = 'Searchapp Android'

    @property
    def tested_application(self):
        return 'searchapp'

    @property
    @sandbox.common.utils.singleton
    def autotests_bundle(self):
        if not self._parameters.enable_autotests or self._context.autotests_timeout <= 0 or not self.tested_builds.get(
                "tests_build"):
            return None
        return get_android_searchapp_autotest_bundle(
            self.tested_builds["tests_build"].id,
            self.tested_builds["browser_build"].id if 'browser_build' in self.tested_builds else None,
            self.tested_builds["fake_build"].id if 'fake_build' in self.tested_builds else None,
            self.clients
        )
