# -*- encoding: utf-8 -*-

from sandbox.common.errors import TaskError
from sandbox.projects.browser.booking import processor
from sandbox.projects.browser.booking.task import BaseBrowserBookingTaskWithConfig


class BrowserBookAssessorTesting(BaseBrowserBookingTaskWithConfig):
    """
    Creates assessor testing bookings.
    See https://wiki.yandex-team.ru/browser/dev/infra/docs/browserbookassessortesting/
    """

    def on_execute(self):
        super(BrowserBookAssessorTesting, self).on_execute()

        sandbox_task = self
        now_datetime_msk = self.now_msk
        dry_run = self.Parameters.dry_run

        class ProcessorImpl(processor.Processor):
            def __init__(self):
                super(ProcessorImpl, self).__init__(
                    sandbox_task.shuttle_client,
                    sandbox_task.booking_client,
                    now_datetime_msk,
                    dry_run)

            @property
            def logger(self):
                return sandbox_task.logger

            def set_info(self, message):
                sandbox_task.set_info(message)

            def notify_responsible(self, project_key, release, message):
                sandbox_task.notify_responsible(project_key, release, message)

        try:
            ProcessorImpl().process(self.booking_config)
        except processor.BookingError as booking_error:
            raise TaskError(booking_error.message)
