# -*- encoding: utf-8 -*-

import os

import yaml

from sandbox import sdk2
from sandbox.projects.browser.booking import commander
from sandbox.projects.browser.booking import common
from sandbox.projects.browser.booking.task import BaseBrowserBookingTaskWithConfig


class BrowserDumpBookingAssessorTesting(BaseBrowserBookingTaskWithConfig):
    """
    Dumps assessor testing bookings.
    See https://wiki.yandex-team.ru/browser/dev/infra/docs/browserbookassessortesting/
    """

    class Parameters(BaseBrowserBookingTaskWithConfig.Parameters):
        include_old_releases = sdk2.parameters.Bool(
            'Include old releases', description='Dump old releases or skip them.',
            default=False)
        restore_missed_bookings = sdk2.parameters.Bool(
            'Restore bookings', description='Restore links between events and missed bookings.',
            default=True)

    def on_execute(self):
        super(BrowserDumpBookingAssessorTesting, self).on_execute()

        cache = common.Cache(self.shuttle_client, self.booking_client)
        dumper = commander.Dumper(cache, self.now_msk, self.Parameters.include_old_releases)
        dump = dumper.dump(self.username, self.booking_config.keys())
        if self.Parameters.restore_missed_bookings:
            dumper.restore_missed_bookings(dump)

        dump_path = str(self.log_path('dump.yaml'))
        with open(dump_path, 'w') as f:
            f.write(yaml.safe_dump(
                dump, width=120, allow_unicode=True, default_flow_style=False))
        self.set_info('Dump saved into: <task log directory>/{}'.format(os.path.basename(dump_path)))
