# -*- encoding: utf-8 -*-

import yaml

from sandbox import sdk2
from sandbox.projects.browser.booking import commander
from sandbox.projects.browser.booking import common
from sandbox.projects.browser.booking.task import BaseBrowserBookingTask


class BrowserRestoreBookingAssessorTesting(BaseBrowserBookingTask):
    """
    Restores assessor testing bookings.
    See https://wiki.yandex-team.ru/browser/dev/infra/docs/browserbookassessortesting/
    """

    class Requirements(BaseBrowserBookingTask.Requirements):
        pass

    class Parameters(BaseBrowserBookingTask.Parameters):
        command_yaml = sdk2.parameters.String(
            'Command', description='Restore command YAML.',
            multiline=True)

    def on_execute(self):
        cache = common.Cache(self.shuttle_client, self.booking_client)

        notifications = []
        try:
            command = yaml.safe_load(self.Parameters.command_yaml)
            commander.execute_commands(cache, command, self.Parameters.dry_run, notifications)
        finally:
            self.set_info('\n'.join(notifications))
