from sandbox.projects.browser.common.git import ConfigureGitEnvironment
from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets

from sandbox import sdk2


class BrowserUpdateWebntpCache(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.resources.update_webntp_cache_resources'

    class Requirements(BuildBrowserTargets.Requirements):
        environments = BuildBrowserTargets.Requirements.environments.default + (
            ConfigureGitEnvironment('teamcity@yandex-team.ru', 'Teamcity'),
        )

    class Parameters(BuildBrowserTargets.Parameters):
        main_id = sdk2.parameters.Resource('Sandbox resource with main resources', required=True)
        static_id = sdk2.parameters.Resource('Sandbox resource with static resources', required=True)
        responsibles = sdk2.parameters.List('List of reviewers and responsible for issues', required=True)
        issue_key = sdk2.parameters.String('Related issue for creating branch names', required=True)

        robot_ssh_key_vault = sdk2.parameters.String(
            'Vault item with ssh key for robot', default='robot-bro-teamcity_ssh_key')

    def script_cmd(self, python_executable):
        args = super(BrowserUpdateWebntpCache, self).script_cmd(python_executable)
        args += ['--main-id', str(self.Parameters.main_id.id)]
        args += ['--static-id', str(self.Parameters.static_id.id)]
        args += ['--responsibles'] + self.Parameters.responsibles
        args += ['--issue-key', self.Parameters.issue_key]

        if self.platform in args:
            args.append(args.pop(args.index(self.platform)))
        return args

    def run_script(self, python_executable):
        with sdk2.ssh.Key(self, self.Parameters.robot_ssh_key_vault, None):
            super(BrowserUpdateWebntpCache, self).run_script(python_executable)
