import os
import subprocess

from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.contextmanagers import ExitStack
from sandbox.projects.browser.common.contextmanagers import TmpdirContext
from sandbox.projects.browser.common.git import repositories

from sandbox import sdk2
from sandbox.sdk2.helpers import ProcessLog


class BuildBrowserBisect(BuildBrowserTargets):
    class Parameters(BuildBrowserTargets.Parameters):
        with sdk2.parameters.Group('Bisect settings') as bisect_settings:
            build_bisect_commit = sdk2.parameters.String('Commit to rollback before build bisect')

    TARGET_MODULE = 'yandex.bisect'
    secret_envvars = BuildBrowserTargets.secret_envvars + (
        'BISECT_S3_ACCESS_KEY',
        'BISECT_S3_SECRET_KEY',
    )

    def script_extra_env(self):
        env = super(BuildBrowserBisect, self).script_extra_env()
        env.update({
            'BISECT_S3_ACCESS_KEY': sdk2.Vault.data('browser_infra_bisect_s3_access_key'),
            'BISECT_S3_SECRET_KEY': sdk2.Vault.data('browser_infra_bisect_s3_secret_key'),
        })
        return env

    def checkout_commit_env(self):
        env = os.environ.copy()
        if self.Parameters.build_bisect_commit:
            env['BUILD_BISECT_COMMIT'] = self.Parameters.build_bisect_commit
        return env

    def checkout_repositories(self):
        super(BuildBrowserBisect, self).checkout_repositories()

        patches_path = str(self.browser_path('browser-bisect-patches'))
        repositories.Stardust.browser_bisect_patches().clone(patches_path, 'master')

        python = sdk2.paths.which('python3') or sdk2.paths.which('python')
        assert python, 'No python found in PATH'
        with ProcessLog(self, logger='checkout_commit') as log:
            subprocess.check_call(
                [python, 'checkout_commit.py', str(self.browser_path()), self.platform],
                cwd=patches_path, env=self.checkout_commit_env(), stdout=log.stdout, stderr=log.stdout)

    def run_script(self, python_executable):
        with ExitStack() as stack:
            if os.name != 'nt':
                # TODO(BYIN-5350): remove TmpdirContext from here.
                stack.enter_context(TmpdirContext('/tmp'))
            super(BuildBrowserBisect, self).run_script(python_executable)
