from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets

from sandbox import sdk2


class BuildBrowserDev(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.dev.build_dev'
    PLATFORMS_RUN_ON_LINUX = ('android', 'linux', 'mac')

    class Requirements(BuildBrowserTargets.Requirements):
        disk_space = 150 * 1024

    class Parameters(BuildBrowserTargets.Parameters):
        max_restarts = 0
        kill_timeout = 9 * 60 * 60
        dev_config_name = sdk2.parameters.String('Config name', required=True)
        region = sdk2.parameters.String('Regions to populate caches in', required=True)
        upload_limit = sdk2.parameters.Integer("Upload limit for each absorber")
        extra_env = sdk2.parameters.String('Additional environment variables to use while build')

    def script_cmd(self, python_executable):
        args = super(BuildBrowserDev, self).script_cmd(python_executable)
        args += ['--region'] + self.Parameters.region.split()
        args += ['--config', self.Parameters.dev_config_name]
        if self.Parameters.upload_limit:
            args += ['--upload-limit', str(self.Parameters.upload_limit)]
        return args

    def script_extra_env(self):
        env = super(BuildBrowserDev, self).script_extra_env()
        env.pop('GCLIENT_RUNHOOKS_CACHE_DIR', None)
        env.pop('GCLIENT_CACHE_DIR', None)
        env.pop('GIT_CACHE_PATH', None)
        env.update(tuple(env_pair.split('=', 1)) for env_pair in self.Parameters.extra_env.split())
        return env
