from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.git import repositories

from sandbox import sdk2


class BuildBrowserIconsPack(BuildBrowserTargets):
    class Parameters(BuildBrowserTargets.Parameters):
        with BuildBrowserTargets.Parameters.repositories_settings() as repositories_settings:
            browser_branch = sdk2.parameters.String('Browser branch to checkout on', default='master')

    TARGET_MODULE = 'yandex.icons.build_icons_pack'

    @property
    def icons_repo_path(self):
        return self.path('icons2020')

    def checkout_repositories(self):
        repositories.Stardust.browser(testing=self.Parameters.use_test_bitbucket).clone(
            str(self.browser_path()), branch=self.Parameters.browser_branch)
        repositories.Stardust.icons2020(filter_branches=False, testing=self.Parameters.use_test_bitbucket).clone(
            str(self.icons_repo_path), self.Parameters.branch, self.Parameters.commit)

    def script_cmd(self, python_executable):
        cmd = super(BuildBrowserIconsPack, self).script_cmd(python_executable)
        cmd += ['--icons-repo-path', str(self.icons_repo_path)]
        return cmd
