from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets

from sandbox import sdk2


class CheckBrowserDeterminism(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.determinism.build'

    class Requirements(BuildBrowserTargets.Requirements):
        disk_space = 220 * 1024

    class Parameters(BuildBrowserTargets.Parameters):
        max_restarts = 0
        kill_timeout = 18 * 60 * 60
        cache_type_for_first = sdk2.parameters.String(
            'Cache type for first', required=True)
        cache_type_for_second = sdk2.parameters.String(
            'Cache type for second', required=True)

    def script_cmd(self, python_executable):
        args = super(CheckBrowserDeterminism, self).script_cmd(python_executable)
        args += [
            '--cache-type-for-first', self.Parameters.cache_type_for_first,
            '--cache-type-for-second', self.Parameters.cache_type_for_second,
        ]
        return args
