from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets

from sandbox import sdk2


class IOSCodeAnalyze(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.ios.code_analyze'

    class Parameters(BuildBrowserTargets.Parameters):
        kill_timeout = 12 * 60 * 60

        with sdk2.parameters.Group('Code analyzer settings') as code_analyzer_settings:
            target = sdk2.parameters.String('GN target', required=True)
            recursive = sdk2.parameters.Bool('Recursive')
            verbose = sdk2.parameters.Bool('Verbose')
            filter = sdk2.parameters.String('Filter')

    def script_cmd(self, python_executable):
        args = super(IOSCodeAnalyze, self).script_cmd(python_executable)
        args += ['--target', self.Parameters.target]
        args += ['--recursive'] if self.Parameters.recursive else []
        args += ['--verbose'] if self.Parameters.verbose else []
        if self.Parameters.filter:
            args += ['--filter={}'.format(self.Parameters.filter)]
        return args
