from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets

from sandbox import sdk2


class IOSLocalBuildPerfTests(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.ios.local_build_perf_tests_build'

    class Parameters(BuildBrowserTargets.Parameters):
        kill_timeout = 12 * 60 * 60

        with sdk2.parameters.Group('Local build perf tests settings') as settings:
            verbose = sdk2.parameters.Bool('Verbose')

    def script_cmd(self, python_executable):
        args = super(IOSLocalBuildPerfTests, self).script_cmd(python_executable)
        args += ['--verbose'] if self.Parameters.verbose else []
        return args
