import os

from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.contextmanagers import ExitStack
from sandbox.projects.browser.common.contextmanagers import TmpdirContext
from sandbox.projects.browser.common.git import ConfigureGitEnvironment

from sandbox import sdk2


class BuildBrowserStatic(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.ci.static'

    class Requirements(BuildBrowserTargets.Requirements):
        environments = BuildBrowserTargets.Requirements.environments.default + (
            ConfigureGitEnvironment('teamcity@yandex-team.ru', 'Teamcity'),
        )

    class Parameters(BuildBrowserTargets.Parameters):
        with BuildBrowserTargets.Parameters.general_settings() as general_settings:
            test_flavor = sdk2.parameters.String('Test flavor')

    def script_cmd(self, python_executable):
        cmd = super(BuildBrowserStatic, self).script_cmd(python_executable)
        if self.Parameters.test_flavor:
            cmd += ['--test-flavor', self.Parameters.test_flavor]
        return cmd

    def run_script(self, python_executable):
        with ExitStack() as stack:
            if os.name != 'nt':
                # TODO(BYIN-5350): remove TmpdirContext from here.
                stack.enter_context(TmpdirContext('/tmp'))
            super(BuildBrowserStatic, self).run_script(python_executable)
