from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.git import ConfigureGitEnvironment

from sandbox import sdk2


class BuildBrowserTests(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.ci.build_tests'

    class Requirements(BuildBrowserTargets.Requirements):
        environments = BuildBrowserTargets.Requirements.environments.default + (
            ConfigureGitEnvironment('teamcity@yandex-team.ru', 'Teamcity'),
        )

    class Parameters(BuildBrowserTargets.Parameters):
        with BuildBrowserTargets.Parameters.general_settings() as general_settings:
            test_flavor = sdk2.parameters.String('Test flavor')
            sanitizer = sdk2.parameters.String('Sanitizer type')

        with sdk2.parameters.Group('MDS expire settings') as mds_expire_settings:
            mds_expire_master = sdk2.parameters.String('Master branches', default='5d')
            mds_expire_merge = sdk2.parameters.String('Merge branches', default='5d')
            mds_expire_default = sdk2.parameters.String('Other branches', default='5d')

    PLATFORMS_RUN_ON_LINUX = ('android', 'linux', 'mac')

    def script_extra_env(self):
        env = super(BuildBrowserTests, self).script_extra_env()
        env.update({
            'MDS_EXPIRE_DEFAULT': str(self.Parameters.mds_expire_default),
            'MDS_EXPIRE_MASTER': str(self.Parameters.mds_expire_master),
            'MDS_EXPIRE_MERGE': str(self.Parameters.mds_expire_merge),
        })
        return env

    def script_cmd(self, python_executable):
        cmd = super(BuildBrowserTests, self).script_cmd(python_executable)
        if self.Parameters.test_flavor:
            cmd += ['--test-flavor', self.Parameters.test_flavor]
        if self.Parameters.sanitizer:
            cmd += ['--san', self.Parameters.sanitizer]
        return cmd
