from sandbox.projects.browser.builds.compiler.BuildDistclangTests import BuildDistclangTests
from sandbox.projects.browser.common.contextmanagers import ExitStack
from sandbox.projects.browser.common.teamcity_step import teamcity_step


class BuildDistclangPerfTests(BuildDistclangTests):
    def on_execute(self):
        with ExitStack() as exit_stack:
            python3_binary = self.checkout_and_sync(exit_stack)
            build_command_arguments = ['build']
            if self.Parameters.platform == 'mac-arm64':
                build_command_arguments.append('--arm64-mac')

            with teamcity_step(self, 'Build Portable flavor', 'build-portable') as tac:
                self.call_integrate(python3_binary, tac.output, build_command_arguments + ['Portable'])

            with teamcity_step(self, 'Run perf tests', 'run-perf-tests') as tac:
                self.call_integrate(python3_binary, tac.output, ['test', '--perf', '--publish-xml'])

            perf_tests_archive = 'perf_tests.tgz'
            with teamcity_step(self, 'Isolate perf tests', 'isolate-perf-tests') as tac:
                self.call_integrate(python3_binary, tac.output, ['isolate', '--perf', '--path', perf_tests_archive])

            with teamcity_step(self, 'Publish artifacts', 'publish-artifacts') as tac:
                artficats_to_publish = (
                    'out/distclang/*.log',
                    'out/Release/dist-clang*',
                    'out/llvm_build_*.log',
                    perf_tests_archive,
                )
                for artifacts_path in artficats_to_publish:
                    tac.logger.info("##teamcity[publishArtifacts '{repo_path}/{mask}']\n".format(
                        repo_path=str(self.repo_path()), mask=artifacts_path))

            if self.Parameters.suspend_before_finish:
                self.suspend()
