import xml.etree.ElementTree as ET


class GTestXmlReader(object):
    def __init__(self, xml_path):
        self.testcases = ET.parse(xml_path).getroot()

    def get_test_info(self, test):
        failures = []
        if test.attrib['status'] == 'notrun':
            return None, None

        for child in test:
            if child.tag == 'failure':
                failures.append(child.attrib['message'])

        if not failures:
            return False, None

        return True, '\n'.join(failures)

    def get_tests_lists_for_testcase(self, testcase):
        passed = dict()
        failed = dict()
        skipped = dict()
        testcase_name = testcase.attrib['name']
        for test in testcase:
            test_name = '{}.{}'.format(testcase_name, test.attrib['name'])
            test_failed, log = self.get_test_info(test)
            if test_failed is None:
                assert log is None
                skipped[test_name] = None
            elif test_failed:
                failed[test_name] = log
            else:
                passed[test_name] = log

        return passed, failed, skipped

    def get_tests(self):
        passed = dict()
        failed = dict()
        skipped = dict()
        for testcase in self.testcases:
            testcase_passed, testcase_failed, testcase_skipped = self.get_tests_lists_for_testcase(testcase)
            passed.update(testcase_passed)
            failed.update(testcase_failed)
            skipped.update(testcase_skipped)

        return passed, failed, skipped
