from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.git import ConfigureGitEnvironment

from sandbox import sdk2


class GenerateDistclangDictionary(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.dev.generate_dictionary'

    class Requirements(BuildBrowserTargets.Requirements):
        environments = BuildBrowserTargets.Requirements.environments.default + (
            ConfigureGitEnvironment('robot-bro-commiter@yandex-team.ru', 'Avatar Claang'),
        )
        disk_space = 160 * 1024

    class Parameters(BuildBrowserTargets.Parameters):
        max_restarts = 2
        kill_timeout = 9 * 60 * 60

        test_mode = sdk2.parameters.Bool('Test mode', default=False)
        reviewers = sdk2.parameters.String('Reviewers to add to PR with dictionary update', required=True)

        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_ssh_key_vault = sdk2.parameters.String(
                'Vault item with ssh key for robot', default='robot-bro-commiter_ssh_key')
            yav_token = sdk2.parameters.String(
                'Vault item with yav.yandex-team.ru OAuth token', default='robot-bro-commiter_yav_token')

    def script_cmd(self, python_executable):
        args = super(GenerateDistclangDictionary, self).script_cmd(python_executable)
        if self.Parameters.test_mode:
            args += ['--test-mode']
        args += ['--reviewers'] + self.Parameters.reviewers.split()
        return args

    def script_extra_env(self):
        env = super(GenerateDistclangDictionary, self).script_extra_env()
        env.update({
            'YAV_TOKEN': sdk2.Vault.data(self.Parameters.yav_token),
        })
        return env

    def run_script(self, python_executable):
        with sdk2.ssh.Key(self, self.Parameters.robot_ssh_key_vault, None):
            super(GenerateDistclangDictionary, self).run_script(python_executable)
