import os

from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.contextmanagers import ExitStack
from sandbox.projects.browser.common.contextmanagers import TmpdirContext


class BuildBrowserBare(BuildBrowserTargets):
    class Parameters(BuildBrowserTargets.Parameters):
        kill_timeout = 10 * 60 * 60

    TARGET_MODULE = 'yandex.dist.bare'

    def run_script(self, python_executable):
        with ExitStack() as stack:
            if os.name != 'nt':
                # TODO(BYIN-5350): remove TmpdirContext from here.
                stack.enter_context(TmpdirContext('/tmp'))
            super(BuildBrowserBare, self).run_script(python_executable)
