import subprocess

from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment

from sandbox import sdk2


class BuildBrowserPerf(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.perf.perf'

    class Parameters(BuildBrowserTargets.Parameters):
        max_restarts = 0
        kill_timeout = 9 * 60 * 60

        browser_tests = sdk2.parameters.String(
            'Browser tests options',
        )

        artifacts = sdk2.parameters.String(
            'Location for publishing artifacts',
        )

    def provide_hpe(self, exit_stack):
        py3_support = subprocess.call(
            ['git', 'merge-base', '--is-ancestor', 'e67a36ca6fdbdbde3b9152713407a8a029c24b7a', 'HEAD'],
            cwd=str(self.browser_path()),
        ) == 0
        if py3_support:
            return super(BuildBrowserPerf, self).provide_hpe(exit_stack)

        requirements_files = [self.browser_path('requirements.txt')]
        if self.depends_on_yin():
            requirements_files.append(self.browser_path('yin', 'requirements.txt'))
        hpe = HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.1',
            requirements_files=requirements_files,
        )
        exit_stack.enter_context(hpe)
        return hpe.python_executable

    def script_cmd(self, python_executable):
        args = super(BuildBrowserPerf, self).script_cmd(python_executable)
        args += (
            self.Parameters.browser_tests +
            ' ' +
            self.Parameters.artifacts
        ).split()

        return args

    def script_extra_env(self):
        env = super(BuildBrowserPerf, self).script_extra_env()
        env.pop('GCLIENT_RUNHOOKS_CACHE_DIR', None)
        env.pop('GCLIENT_CACHE_DIR', None)
        env.pop('GIT_CACHE_PATH', None)

        return env
