import os
import subprocess
import time

from sandbox import sdk2
import sandbox.common.types.client as ctc

from sandbox.projects.browser import common
from sandbox.projects.browser.common.git import GitEnvironment, repositories
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment
from sandbox.projects.common.teamcity import TeamcityServiceMessagesLog


# Deprecated. Use `sandbox.projects.browser.common.RunYinScript.RunYinScript` instead.
class RunFromYinTask(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.Group.LINUX
        cores = 16
        ram = 32 * 1024
        environments = [
            GitEnvironment('2.19'),
        ]

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        yin_branch = sdk2.parameters.String(
            'Branch in YIN repo to get scripts from',
            default='master')
        yin_commit = sdk2.parameters.String(
            'Commit in YIN repo to get scripts from')

        _container = sdk2.parameters.Container(
            'Linux container', default_value=common.LXC_RESOURCE_ID)

    def yin_path(self, *args):
        return str(self.path('yin', *args))

    def run_yin_script(self, script_path, script_args, extra_env=None, clone_yin=True):
        '''
        Checkouts script from yin, saves its output in TeamcityServiceMessagesLog
        resource
        '''
        if clone_yin:
            repositories.Stardust.yin(filter_branches=False).clone(
                self.yin_path(), self.Parameters.yin_branch,
                commit=self.Parameters.yin_commit or None)
        log_file = os.path.abspath('tclog-{}.txt'.format(int(time.time())))
        with HermeticPythonEnvironment(
            python_version='3.9.7',
            pip_version='20.3.4',
            requirements_files=[sdk2.Path(self.yin_path('requirements.txt'))],
        ) as hpe:
            log_resource = TeamcityServiceMessagesLog(self, 'script log', log_file)
            try:
                with open(log_file, 'w') as f:
                    command = [str(hpe.python_executable), '-m', script_path] + script_args
                    f.write('Running: {}\n'.format(
                        ' '.join(repr(arg) for arg in command)))
                    env = os.environ.copy()
                    # BYIN-12916 Do not pass PYTHONPATH of Sandbox task to the child script.
                    env['PYTHONPATH'] = ''
                    if extra_env:
                        env.update(extra_env)
                    subprocess.check_call(command, stdout=f, stderr=f,
                                          cwd=self.yin_path(), env=env)
            finally:
                sdk2.ResourceData(log_resource).ready()
