import logging
import smtplib
from email.mime.text import MIMEText

SMTP_URL = 'yabacks.yandex.ru'
SMTP_PORT = 25


def send_email(sender_email, recipients, subject, text, reply_to=None, headers=None, dry_run=False):
    """

    :param recipients: sequence of recipient emails
    """
    message = MIMEText(text, _subtype='html', _charset='utf-8')
    message['Subject'] = subject
    message['From'] = sender_email
    message['To'] = ', '.join(recipients)
    if reply_to:
        message['Reply-To'] = reply_to
    if headers:
        for k, v in headers.iteritems():
            message[k] = v

    logging.info('Sending email to %s', recipients)
    if dry_run:
        logging.info('Skip sending email because of dry run mode')
    else:
        email_client = smtplib.SMTP(SMTP_URL, SMTP_PORT)
        try:
            email_client.ehlo_or_helo_if_needed()
            email_client.sendmail(sender_email, recipients, message.as_string())
        finally:
            email_client.quit()
