import contextlib

from sandbox.common import errors

from sandbox.projects.common.teamcity import TeamcityArtifactsContext


@contextlib.contextmanager
def teamcity_step(sandbox_task, name, log_name):
    sandbox_task.set_info(name)

    tac = TeamcityArtifactsContext(
        path_suffix='step-{}'.format(log_name), log_name=log_name,
        tc_service_messages_description='Step[{}]'.format(name))
    with tac:
        try:
            yield tac
        except errors.TemporaryError:
            tac.logger.exception('Step "{}" failed - TemporaryError'.format(name))
            raise
        except Exception:
            tac.logger.exception('Step "{}" failed'.format(name))
            tac.logger.info("##teamcity[buildProblem description='{}']".format(
                'Step "{}" failed.'.format(name)))
            raise
