import logging
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment
from sandbox.projects.common.environments import SandboxGitEnvironment


class BrowserCrashesDaily(sdk2.Task):
    """Task for running browser crash analytics script"""

    class Requirements(sdk2.Task.Requirements):
        environments = (
            SandboxGitEnvironment(),
        )

        disk_space = 512
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 5 * 60 * 60

    def rel_path(self, *args):
        return self.path('gemor', *args)

    def on_execute(self):
        yt_token = sdk2.Vault.data('gemor-yt-token')
        yql_token = sdk2.Vault.data('gemor-yql-token')

        repositories.Personal.gemor().clone(
            str(self.rel_path())
        )
        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.1',
            requirements_files=[self.rel_path('requirements.txt')],
        ) as hpe:
            env = os.environ.copy()
            env['YT_TOKEN'] = yt_token
            env['YQL_TOKEN'] = yql_token

            with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('gemor')) as pl:
                cmd = [str(hpe.python_executable), str(self.rel_path('gemor.py')), '-v', 'daily']
                subprocess.check_call(cmd, env=env, stdout=pl.stdout, stderr=subprocess.STDOUT)
