from sandbox import sdk2


class BrowserBinTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Binary task parameters'):
            use_last_binary = sdk2.parameters.Bool('Use last binary archive', default=True)
            with use_last_binary.value[True]:
                with sdk2.parameters.RadioGroup('Binary release type') as release_type:
                    release_type.values.stable = release_type.Value('stable', default=True)
                    release_type.values.test = release_type.Value('test')

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(
                attrs={
                    'target': 'sandbox/projects/browser/bin',
                    'release': self.Parameters.release_type or 'stable',
                }).first().id
        else:
            self.Requirements.tasks_resource = None

        super(BrowserBinTask, self).on_save()
