from sandbox import sdk2
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.browser.localization.common import (
    BrowserLocalizationKeyset, BrowserLocalizationDisplayKeysetBase,
    KEYSET_TYPES,
)


class BrowserLocalizationCompareKeysets(BrowserLocalizationDisplayKeysetBase):
    JS_CONTAINER_RESOURCE = 2092548714

    class Parameters(BrowserLocalizationDisplayKeysetBase.Parameters):
        with sdk2.parameters.Group('Keyset settings') as keyset_group:
            first_keyset_type = sdk2.parameters.String('Project to display',
                                                       choices=KEYSET_TYPES,
                                                       required=True, ui=sdk2.parameters.String.UI("select"))
            first_revision = sdk2.parameters.String('Revision to display', required=True)
            second_keyset_type = sdk2.parameters.String('Project to display',
                                                        choices=KEYSET_TYPES,
                                                        required=True, ui=sdk2.parameters.String.UI("select"))
            second_revision = sdk2.parameters.String('Revision to display', required=True)

    def on_execute(self):
        super(BrowserLocalizationCompareKeysets, self).on_execute()

        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.1',
            packages=[self.Parameters.package],
        ) as hpe:
            with sdk2.helpers.ProcessLog(self, logger='compare_keysets') as pl:
                subprocess.check_call([
                    str(hpe.python_executable),
                    '-m', 'localization_core.visualizers.view_keyset',
                    '--output', str(self.keyset_dir_path('first_keyset.json')),
                    '--keyset-type', self.Parameters.first_keyset_type,
                    '--revision', self.Parameters.first_revision,
                ], stderr=pl.stdout)
                subprocess.check_call([
                    str(hpe.python_executable),
                    '-m', 'localization_core.visualizers.view_keyset',
                    '--output', str(self.keyset_dir_path('second_keyset.json')),
                    '--keyset-type', self.Parameters.second_keyset_type,
                    '--revision', self.Parameters.second_revision,
                ], stderr=pl.stdout)

            keyset_resource = BrowserLocalizationKeyset(self, 'Keyset view', self.keyset_dir_path())
            sdk2.ResourceData(keyset_resource).ready()
            self.set_info(
                'Comparison available here: <a href="{0}/main.html">{0}/main.html</a>'.format(
                    keyset_resource.http_proxy
                ),
                do_escape=False
            )
