from sandbox import sdk2
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment
from sandbox.sdk2.helpers import subprocess
from sandbox.projects.browser.localization.common import (
    BrowserLocalizationKeyset, BrowserLocalizationDisplayKeysetBase,
    KEYSET_TYPES,
)


class BrowserLocalizationDisplayKeyset(BrowserLocalizationDisplayKeysetBase):
    class Parameters(BrowserLocalizationDisplayKeysetBase.Parameters):
        with sdk2.parameters.Group('Keyset settings') as keyset_group:
            keyset_type = sdk2.parameters.String('Project to display',
                                                 choices=KEYSET_TYPES,
                                                 required=True, ui=sdk2.parameters.String.UI("select"))
            revision = sdk2.parameters.String('Revision to display', required=True)

    def on_execute(self):
        super(BrowserLocalizationDisplayKeyset, self).on_execute()
        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.1',
            packages=[self.Parameters.package],
        ) as hpe:
            with sdk2.helpers.ProcessLog(self, logger='view_keyset') as pl:
                subprocess.check_call([
                    str(hpe.python_executable),
                    '-m', 'localization_core.visualizers.view_keyset',
                    '--output', str(self.keyset_dir_path('keyset.json')),
                    '--keyset-type', self.Parameters.keyset_type,
                    '--revision', self.Parameters.revision
                ], stderr=pl.stdout)
            keyset_resource = BrowserLocalizationKeyset(self, 'Keyset view', self.keyset_dir_path())
            sdk2.ResourceData(keyset_resource).ready()
            self.set_info(
                '{0} view available here: <a href="{1}/main.html">{1}/main.html</a>'.format(
                    self.Parameters.keyset_type,
                    keyset_resource.http_proxy
                ),
                do_escape=False
            )
