# coding: utf-8
import sandbox.common.types.client as ctc
import sandbox.common.types.task as ctt

from sandbox.projects.browser.builds.BuildBrowserTargets import BuildBrowserTargets
from sandbox import sdk2
from sandbox.projects.browser.common.RunBrowserScript import RunBrowserScript
from sandbox.projects.browser.common.git import ConfigureGitEnvironment


class BrowserLocalizationTankerToIOSTask(BuildBrowserTargets):
    TARGET_MODULE = 'yandex.ios.tanker_to_repo_localization_build'

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.OSX_BIG_SUR
        environments = RunBrowserScript.Requirements.environments.default + (
            ConfigureGitEnvironment('robot-bro-locabr@yandex-team.ru', 'Browser Localization'),
        )

    class Parameters(BuildBrowserTargets.Parameters):
        reviewers = sdk2.parameters.List('Reviewers', default=['i-dtrifonov', 'aldonin'], required=True)
        key_sets = sdk2.parameters.List('Keysets', default=[])
        assignee = sdk2.parameters.String('Assignee', default='i-dtrifonov', required=True)
        release_ticket = sdk2.parameters.String('Release_ticket', default='MOBREL-4181', required=True)
        components = sdk2.parameters.List('Components', default=['Localization'])
        fix_version = sdk2.parameters.String('Release_version', default='Master', required=True)

        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_ssh_key_vault = sdk2.parameters.String('Vault item with ssh key for bitbucket',
                                                         default='robot-bro-locabr_ssh_key')

    def on_enqueue(self):
        super(BrowserLocalizationTankerToIOSTask, self).on_enqueue()
        self.Parameters.notifications += [
            sdk2.Notification(
                statuses=[
                    ctt.Status.FAILURE,
                    ctt.Status.EXCEPTION,
                    ctt.Status.TIMEOUT,

                ],
                recipients=["{}@yandex-team.ru".format(self.Parameters.assignee)],
                transport='email'
            )
        ]

    def script_cmd(self, python_executable):
        args = super(BrowserLocalizationTankerToIOSTask, self).script_cmd(python_executable)
        args += [
            '--assignee', self.Parameters.assignee,
            '--release_ticket', self.Parameters.release_ticket,
            '--fix_version', self.Parameters.fix_version,
            '--branch', self.Parameters.branch
        ]
        args += ['--reviewers'] + self.Parameters.reviewers
        args += ['--components'] + self.Parameters.components
        if self.Parameters.key_sets:
            args += ['--keysets'] + self.Parameters.key_sets
        return args

    def run_script(self, python_executable):
        with sdk2.ssh.Key(self, self.Parameters.robot_ssh_key_vault, None):
            super(BrowserLocalizationTankerToIOSTask, self).run_script(python_executable)
