import os

import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment
from sandbox.projects.browser.localization.common import TANKER_TYPES


class BrowserLocalizationUnapprovedKeysReport(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.Group.LINUX
        cores = 4
        ram = 8 * 1024  # 8 GB
        disk_space = 32 * 1024  # 32 GB

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        package = sdk2.parameters.String('Name or path to browser-localization-core package',
                                         required=True, default='browser-localization-core==4.2.1')
        keyset_type = sdk2.parameters.String('Send the report about this keyset',
                                             choices=TANKER_TYPES,
                                             required=True, ui=sdk2.parameters.String.UI("select"))
        branch = sdk2.parameters.String('Tanker branch for the report', required=True)
        recipients = sdk2.parameters.List('Email recipients', default=[])

        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_oauth_token = sdk2.parameters.String('Vault item with token for robot OAuth token',
                                                       default='robot-bro-locabr_oauth_token')

        _container = sdk2.parameters.Container('LXC container', default_value=1414674927, required=True)

    @property
    def repo_path(self):
        return str(self.path('browser'))

    def on_execute(self):
        vcs_root = repositories.Stardust.browser()
        vcs_root.clone(self.repo_path, branch=self.Parameters.branch)

        env_vars = os.environ.copy()
        env_vars.update({
            'TANKER_OAUTH_TOKEN': sdk2.Vault.data(self.Parameters.robot_oauth_token),
            'BITBUCKET_OAUTH_TOKEN': sdk2.Vault.data(self.Parameters.robot_oauth_token),
            'STARTREK_OAUTH_TOKEN': sdk2.Vault.data(self.Parameters.robot_oauth_token),
            'BROWSER_BARE_REPO': self.repo_path,
        })
        script_params = ['--keyset-type', self.Parameters.keyset_type,
                         '--branch', self.Parameters.branch,
                         '--admin-recipients'] + self.Parameters.recipients

        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.1',
            packages=[self.Parameters.package],
        ) as hpe:
            with sdk2.helpers.ProcessLog(self, logger='update_localization_tickets') as pl:
                subprocess.check_call(
                    [str(hpe.python_executable), '-m',
                     'localization_core.scripts.translation_status.not_approved_report'
                     ] + script_params,
                    env=env_vars, stderr=pl.stdout
                )
