import logging
import re

import sandbox.common.types.client as ctc
from sandbox import sdk2
from sandbox.projects.browser.common.binary_tasks import MacBinaryTaskMixin
from sandbox.sdk2.helpers import subprocess


class BrowserClearRosettaCache(MacBinaryTaskMixin, sdk2.Task):
    CACHE_PATH = '/private/var/db/oah/'

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.Group.OSX & ctc.Tag.M1

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    @staticmethod
    def get_folder_size_in_megabytes(path):
        output = subprocess.check_output(
            "du -sm {} | awk '{{print $1}}'".format(path), shell=True, stderr=subprocess.STDOUT
        )
        output = output.decode('utf-8').strip()
        size_in_mb = int(output)
        return size_in_mb

    def on_execute(self):
        size_before_in_mb = self.get_folder_size_in_megabytes(self.CACHE_PATH)
        logging.debug(
            'Size of {path} before: {size} MB'.format(path=self.CACHE_PATH, size=size_before_in_mb)
        )

        try:
            # Delete all directories inside /private/var/db/oah/. Cache of sandbox task itself is also stored here,
            # so command will fail with error 'Directory not empty'.
            find_output = subprocess.check_output(
                'sudo find {}* -maxdepth 0 -type d -exec rm -rf {{}} +'.format(self.CACHE_PATH),
                shell=True,
                stderr=subprocess.STDOUT
            )
            logging.debug(find_output)
        except subprocess.CalledProcessError as e:
            error_info = "command '{}' return with error (code {}): {}".format(e.cmd, e.returncode, e.output)

            # TODO: change to .fullmatch() when move to Python 3.
            check_error_output_regex = re.compile(
                '^rm: {path}[0-9a-f]{{64}}: Directory not empty$'.format(path=self.CACHE_PATH)
            )
            if check_error_output_regex.match(e.output) is None:
                logging.debug('Non-expected error output!')
            logging.debug(error_info)

        size_after_in_mb = self.get_folder_size_in_megabytes(self.CACHE_PATH)
        logging.debug(
            'Size of {path} after: {size} MB'.format(path=self.CACHE_PATH, size=size_after_in_mb)
        )

        # Find all remaining directories after deletion.
        remaining_caches = subprocess.check_output(
            'find {}* -maxdepth 0 -type d'.format(self.CACHE_PATH), shell=True, stderr=subprocess.STDOUT
        )
        remaining_caches_lines = remaining_caches.decode('utf-8').strip().split('\n')

        # The only directory that may not be deleted is cache of this sandbox task BROWSER_CLEAR_ROSETTA_CACHE itself.
        assert len(remaining_caches_lines) <= 1, 'Only cache of BROWSER_CLEAR_ROSETTA_CACHE itself should remain'

        logging.debug('Cache of Rosetta cleared (everything but cache of BROWSER_CLEAR_ROSETTA_CACHE task itself)')
