import logging
import os

from sandbox.common import config
import sandbox.common.types.client as ctc

from sandbox.projects.browser.common import binary_tasks

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess

DB_PATH = '/Library/Application Support/com.apple.TCC/TCC.db'


class ClearBrowserAccessibilityPermissions(binary_tasks.CrossPlatformBinaryTaskMixin, sdk2.Task):
    """
    Clear accessibility permissions to files in `/place/sandbox-data/tasks` on macOS host.

    Some tests can add such permissions and do not remove them, so this task can be useful as regular job.
    """

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.Group.OSX
        disk_space = 100

    class Parameters(sdk2.Task.Parameters):
        _binary_task_params = binary_tasks.cross_platform_binary_task_parameters(linux=False, win=False)

    def on_execute(self):
        tasks_dir = str(config.Registry().client.tasks.data_dir)

        sql_query = 'SELECT client FROM access WHERE service IN ("kTCCServiceAccessibility", "kTCCServicePostEvent")'
        paths = subprocess.check_output(['sqlite3', DB_PATH, sql_query]).splitlines()

        for path in paths:
            if path.startswith(tasks_dir + os.sep):
                logging.info('Remove permission for %s', path)
                subprocess.check_call(['sudo', 'tccutil', '--remove', path])
            else:
                logging.debug('Skip %s', path)
