from sandbox.projects.browser.maintenance import client_helpers

from sandbox import sdk2


class UpdateBrowserClientsTags(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 100

    class Parameters(sdk2.Task.Parameters):
        clients = sdk2.parameters.List('Clients')
        add_tags = sdk2.parameters.List('CUSTOM tags to add')
        remove_tags = sdk2.parameters.List('CUSTOM tags to remove')

    def on_execute(self):
        add_tags = filter(None, self.Parameters.add_tags)
        remove_tags = filter(None, self.Parameters.remove_tags)
        for client_id in self.Parameters.clients:
            client_helpers.BrowserClient(client_id).update_tags(add_tags, remove_tags)
