# coding=utf-8

from argparse import ArgumentParser


def touch_file(force_revert_path, issue_key):
    from ruamel.yaml import YAML
    yaml = YAML()
    with open(force_revert_path, 'r') as f:
        reverts = yaml.load(f)
    if not reverts:
        # yaml has only root comment and no other info
        with open(force_revert_path, 'a') as f:
            f.write('{}: 1'.format(issue_key))
    else:
        reverts[issue_key] = reverts.get(issue_key, 0) + 1
        with open(force_revert_path, 'w') as f:
            yaml.dump(reverts, f)


def run():
    parser = ArgumentParser()
    parser.add_argument('file_path'),
    parser.add_argument('issue_key'),
    args = parser.parse_args()

    touch_file(args.file_path, args.issue_key)


if __name__ == '__main__':
    run()
