# coding=utf-8
from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.common.utils import singleton_property
from sandbox.projects.browser.common.bitbucket import (
    BitBucket, DEFAULT_BITBUCKET_URL, TESTING_BITBUCKET_URL
)
from sandbox.projects.browser.common.git import GitEnvironment, repositories
from sandbox.projects.browser.common.git.git_cli import GitCli, GitHelper


class BrowserMergeBase(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        disk_space = 20 * 1024  # 20GB
        cores = 16
        ram = 32 * 1024
        client_tags = ctc.Tag.BROWSER & ctc.Tag.Group.LINUX
        environments = [
            GitEnvironment('2.19'),
        ]

        class Caches(sdk2.Task.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        dry_run = sdk2.parameters.Bool('Dry run')
        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_login = sdk2.parameters.String('Robot login', default='robot-bro-merge')
            oauth_vault = sdk2.parameters.String('Vault item with token for teamcity & bitbucket',
                                                 default='robot-bro-merge_token')
            robot_ssh_key_vault = sdk2.parameters.String('Vault item with ssh key for bitbucket',
                                                         default='robot-bro-merge_ssh_key')

    def repo_path(self, *args):
        return str(self.path('browser', *args))

    @singleton_property
    def bb(self):
        if self.Parameters.dry_run:
            bitbucket_url = TESTING_BITBUCKET_URL
        else:
            bitbucket_url = DEFAULT_BITBUCKET_URL
        return BitBucket(bitbucket_url, 'x-oauth-token', sdk2.Vault.data(self.Parameters.oauth_vault))

    @singleton_property
    def git(self):
        return GitCli(self.repo_path())

    @singleton_property
    def git_helper(self):
        return GitHelper(self.repo_path())

    def clone_repo(self, branch):
        repo = repositories.Stardust.browser(testing=self.Parameters.dry_run)
        # FIXME update_cache is used here, because without it cloning branch fails on branch, which is a suffix of
        # another branch. e.g. cloning feature/19.10 fails if branch bundle/feature/19.10 exists.
        repo.update_cache_repo()
        repo.clone(self.repo_path(), branch, config={
            'user.name': self.Parameters.robot_login,
            'user.email': '{}@yandex-team.ru'.format(self.Parameters.robot_login),
        })
        return repo
