import os

from sandbox import sdk2
from sandbox.projects.browser.common.RunFromYinTask import RunFromYinTask
from sandbox.projects.common import teamcity


class BrowserMergeCollectErrors(RunFromYinTask):
    class Requirements(RunFromYinTask.Requirements):
        pass

    class Parameters(RunFromYinTask.Parameters):
        branch = sdk2.parameters.String('Branch in browser repo')
        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_login = sdk2.parameters.Staff(
                'Robot login', default='robot-bro-merge')
            robot_token = sdk2.parameters.String(
                'Vault item with robot token',
                default='robot-bro-merge_token')

    @property
    def artifacts_path(self):
        return self.path('artifacts')

    @property
    def errors_output(self):
        return os.path.join(str(self.artifacts_path), 'errors.json')

    @property
    def errors_logs_output(self):
        return os.path.join(str(self.artifacts_path), 'errors.logs.json')

    @property
    def outputs(self):
        return {
            self.errors_output,
            self.errors_logs_output,
        }

    def on_execute(self):
        branch = self.Parameters.branch
        if branch.startswith('refs/heads/'):
            branch = branch.split('/', 2)[-1]
        args = [
            branch, str(self.errors_output), str(self.errors_logs_output),
            '-vvv',
            '--oauth-login', self.Parameters.robot_login,
            '--oauth-token-env', 'robot_token',
            '--oauth-no-save',
        ]

        os.makedirs(str(self.artifacts_path))
        try:
            self.run_yin_script(
                'yin.merge.reports.errors', args,
                extra_env=dict(
                    robot_token=sdk2.Vault.data(
                        self.Parameters.robot_token)))
        finally:
            if os.listdir(str(self.artifacts_path)):
                artifacts_resource = teamcity.TeamcityArtifacts(
                    self, 'Teamcity artifacts', self.artifacts_path)
                sdk2.ResourceData(artifacts_resource).ready()
